/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	PrincessStatue
**
** DESCRIPTION:	Princess statue repair puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef PRINCESSSTATUE_H
#define PRINCESSSTATUE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "Puzzle.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const ldwPoint PrincessStatue_c_sScaffoldingPos = ldwPoint(790, 235);

const int PrincessStatue_c_iMaxVillagersPushing = 20;
const unsigned int PrincessStatue_c_uiPushTimeForOneVillager = 240 * 60 * 60;

const int PrincessStatue_c_iStatuePositions = 4;
const ldwPoint PrincessStatue_c_sStatuePos[PrincessStatue_c_iStatuePositions] = {
	ldwPoint(700, 460), 
	ldwPoint(860, 460), 
	ldwPoint(860, 120),
	ldwPoint(772, 64)
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CPrincessStatue : public IPuzzle
{
	friend class CPuzzle;

private:

	//class enumerations
	enum EState
	{
		eState_ConstructingScaffolding = 0,
		eState_TransportingStatue,
		eState_RepairedStatue,

		eState_NumberOf
	};

	enum ERef
	{
		eRef_Statue = ePuzzle_PrincessStatue + (1 << 16),
		eRef_Scaffolding = ePuzzle_PrincessStatue + (2 << 16)
	};

	//class structures
	struct SPusher
	{
		int				m_iRef;
		int				m_iOffset;
		int				m_iPushTime;
	};

	struct SSaveState
	{
		EState			m_eState;
		int				m_iWorkTime;
		ldwPoint		m_sStatuePos;
	};

	//class data
	static const ldwPoint		scm_sPusherOffset[PrincessStatue_c_iMaxVillagersPushing];

	EState			m_eState;
	SPusher			m_sVillagerPushingStatue[PrincessStatue_c_iMaxVillagersPushing];
	int				m_iNumVillagersPushing;
	int				m_iWorkTime;
	ldwPoint		m_sStatuePos;

	ldwImage *		m_pScaffolding;
	ldwImageGrid *	m_pStatueFallen;
	ldwImageGrid *	m_pStatueErect;

	//class methods
	//setup
	public:		CPrincessStatue(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();
	public:		void Advance(CVillager &Villager, const int iRef);
	public:		void Complete();
	public:		const ldwPoint AddPusher(const int iRef, const int iPushTime);

	// access
	public:		const bool IsNearToStatue(const ldwPoint sPos) const;
	public:		const bool IsRoomForAnotherPusher() const;
	public:		const bool IsPusherAtOffset(const int iOffset) const;
	public:		const bool IsRepaired() const { return m_eState >= eState_RepairedStatue; }
	public:		const bool WasScaffoldingConstructed() const { return m_eState > eState_ConstructingScaffolding; }
	public:		const int EstimatedRepairTime() const;
	public:		const bool IsStatueInTransportingPhase() const;

};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CPrincessStatue		PrincessStatue;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/